<?php
$options = array(
	'colormag_social_icons_heading'          => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Social Icons', 'colormag' ),
		'section'      => 'colormag_social_icons_section',
		'sub_controls' => apply_filters(
			'colormag_social_icons_controls',
			array(
				'colormag_enable_social_icons' => array(
					'title'     => esc_html__( 'Enable', 'colormag' ),
					'default'   => false,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_social_icons_section',
					'transport' => 'refresh',
					'partial'   => array(
						'selector' => '.social-links',
					),
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_social_icons_accordion_collapsible', false ),
	),
	'colormag_social_icons_position_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Position', 'colormag' ),
		'section'      => 'colormag_social_icons_section',
		'sub_controls' => apply_filters(
			'colormag_social_icons_position_controls',
			array(
				'colormag_enable_social_icons_header'   => array(
					'title'     => esc_html__( 'Header', 'colormag' ),
					'default'   => true,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_social_icons_section',
					'transport' => 'refresh',
					'partial'   => array(
						'selector' => '.social-links',
					),
				),
				'colormag_social_icons_header_location' => array(
					'default'   => 'top-bar',
					'type'      => 'customind-select',
					'title'     => esc_html__( 'Header Location', 'colormag' ),
					'section'   => 'colormag_social_icons_section',
					'choices'   => array(
						'top-bar' => esc_html__( 'Top Bar', 'colormag' ),
						'menu'    => esc_html__( 'Menu', 'colormag' ),
					),
					'condition' => array(
						'colormag_enable_social_icons_header',
						'==',
						true,
					),
				),
				'colormag_enable_social_icons_footer'   => array(
					'title'     => esc_html__( 'Footer', 'colormag' ),
					'default'   => true,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_social_icons_section',
					'transport' => 'refresh',
					'partial'   => array(
						'selector' => '.social-links',
					),
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_social_icons_position_accordion_collapsible', false ),
		'condition'    => array(
			'colormag_enable_social_icons' => true,
		),
	),
);

// Social links lists.
$social_links_count    = 70;
$colormag_social_links = array(
	'colormag_social_facebook'    => array(
		'id'      => 'colormag_social_facebook',
		'title'   => esc_html__( 'Facebook', 'colormag' ),
		'default' => '',
	),
	'colormag_social_twitter'     => array(
		'id'      => 'colormag_social_twitter',
		'title'   => esc_html__( 'Twitter', 'colormag' ),
		'default' => '',
	),
	'colormag_social_instagram'   => array(
		'id'      => 'colormag_social_instagram',
		'title'   => esc_html__( 'Instagram', 'colormag' ),
		'default' => '',
	),
	'colormag_social_pinterest'   => array(
		'id'      => 'colormag_social_pinterest',
		'title'   => esc_html__( 'Pinterest', 'colormag' ),
		'default' => '',
	),
	'colormag_social_youtube'     => array(
		'id'      => 'colormag_social_youtube',
		'title'   => esc_html__( 'YouTube', 'colormag' ),
		'default' => '',
	),
	'colormag_social_vimeo'       => array(
		'id'      => 'colormag_social_vimeo',
		'title'   => esc_html__( 'Vimeo-Square', 'colormag' ),
		'default' => '',
	),
	'colormag_social_linkedin'    => array(
		'id'      => 'colormag_social_linkedin',
		'title'   => esc_html__( 'LinkedIn', 'colormag' ),
		'default' => '',
	),
	'colormag_social_delicious'   => array(
		'id'      => 'colormag_social_delicious',
		'title'   => esc_html__( 'Delicious', 'colormag' ),
		'default' => '',
	),
	'colormag_social_flickr'      => array(
		'id'      => 'colormag_social_flickr',
		'title'   => esc_html__( 'Flickr', 'colormag' ),
		'default' => '',
	),
	'colormag_social_skype'       => array(
		'id'      => 'colormag_social_skype',
		'title'   => esc_html__( 'Skype', 'colormag' ),
		'default' => '',
	),
	'colormag_social_soundcloud'  => array(
		'id'      => 'colormag_social_soundcloud',
		'title'   => esc_html__( 'SoundCloud', 'colormag' ),
		'default' => '',
	),
	'colormag_social_vine'        => array(
		'id'      => 'colormag_social_vine',
		'title'   => esc_html__( 'Vine', 'colormag' ),
		'default' => '',
	),
	'colormag_social_stumbleupon' => array(
		'id'      => 'colormag_social_stumbleupon',
		'title'   => esc_html__( 'StumbleUpon', 'colormag' ),
		'default' => '',
	),
	'colormag_social_tumblr'      => array(
		'id'      => 'colormag_social_tumblr',
		'title'   => esc_html__( 'Tumblr', 'colormag' ),
		'default' => '',
	),
	'colormag_social_reddit'      => array(
		'id'      => 'colormag_social_reddit',
		'title'   => esc_html__( 'Reddit', 'colormag' ),
		'default' => '',
	),
	'colormag_social_xing'        => array(
		'id'      => 'colormag_social_xing',
		'title'   => esc_html__( 'Xing', 'colormag' ),
		'default' => '',
	),
	'colormag_social_vk'          => array(
		'id'      => 'colormag_social_vk',
		'title'   => esc_html__( 'VK', 'colormag' ),
		'default' => '',
	),
	'colormag_social_discord'     => array(
		'id'      => 'colormag_social_discord',
		'title'   => esc_html__( 'Discord', 'colormag' ),
		'default' => '',
	),
);

// Available social links via theme.
foreach ( $colormag_social_links as $colormag_social_link ) {

	// Social links url option.
	$options[ $colormag_social_link['id'] ] = array(
		'title'     => $colormag_social_link['title'],
		'default'   => $colormag_social_link['default'],
		'type'      => 'customind-text',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $social_links_count,
	);

	// Social links open in new tab enable/disable option.
	$options[ $colormag_social_link['id'] . '_checkbox' ] = array(
		'title'     => esc_html__( 'Check to open in new tab', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-checkbox',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $social_links_count,
	);

	// Social links separator.
	$options[ $colormag_social_link['id'] . '_separator' ] = array(
		'type'      => 'customind-divider',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $social_links_count,
	);

	++$social_links_count;
}

// Custom available social links.
$additional_social_links_count = 150;
$user_custom_social_links      = array(
	'user_custom_social_links_one'   => array(
		'id'      => 'user_custom_social_links_one',
		'title'   => esc_html__( 'Additional Social Link One', 'colormag' ),
		'default' => '',
	),
	'user_custom_social_links_two'   => array(
		'id'      => 'user_custom_social_links_two',
		'title'   => esc_html__( 'Additional Social Link Two', 'colormag' ),
		'default' => '',
	),
	'user_custom_social_links_three' => array(
		'id'      => 'user_custom_social_links_three',
		'title'   => esc_html__( 'Additional Social Link Three', 'colormag' ),
		'default' => '',
	),
	'user_custom_social_links_four'  => array(
		'id'      => 'user_custom_social_links_four',
		'title'   => esc_html__( 'Additional Social Link Four', 'colormag' ),
		'default' => '',
	),
	'user_custom_social_links_five'  => array(
		'id'      => 'user_custom_social_links_five',
		'title'   => esc_html__( 'Additional Social Link Five', 'colormag' ),
		'default' => '',
	),
	'user_custom_social_links_six'   => array(
		'id'      => 'user_custom_social_links_six',
		'title'   => esc_html__( 'Additional Social Link Six', 'colormag' ),
		'default' => '',
	),
);
foreach ( $user_custom_social_links as $user_custom_social_link ) {

	// Social links url option.
	$options[ $user_custom_social_link['id'] ] = array(
		'title'     => $user_custom_social_link['title'],
		'default'   => $user_custom_social_link['default'],
		'type'      => 'customind-text',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $additional_social_links_count,
	);

	// Social links fontawesome icon option.
	$options[ $user_custom_social_link['id'] . '_fontawesome' ] = array(
		'title'     => esc_html__( 'Preferred Social Link FontAwesome Icon', 'colormag' ),
		'default'   => '',
		'type'      => 'customind-text',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $additional_social_links_count,
	);

	// Social links icon color option.
	$options[ $user_custom_social_link['id'] . '_color' ] = array(
		'title'     => esc_html__( 'Preferred Social Link Color Option', 'colormag' ),
		'default'   => '',
		'type'      => 'customind-text',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $additional_social_links_count,
	);

	// Social links open in new tab enable/disable option.
	$options[ $user_custom_social_link['id'] . '_checkbox' ] = array(
		'title'     => esc_html__( 'Check to open in new tab', 'colormag' ),
		'default'   => '',
		'type'      => 'customind-checkbox',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $additional_social_links_count,
	);

	// Social links separator.
	$options[ $user_custom_social_link['id'] . '_separator' ] = array(
		'type'      => 'customind-divider',
		'section'   => 'colormag_social_icons_section',
		'condition' => array(
			'colormag_enable_social_icons' => true,
		),
		'priority'  => $additional_social_links_count,
	);

	++$additional_social_links_count;
}


colormag_customind()->add_controls( $options );
